function output = fct_decomposition_increments(DECOMPinput)
    % tmin, tmax -- interval for decomposition    

    tmin = 0;
    tmax = 104;
    
    mm_mat = fieldnames(DECOMPinput);
    for i = 1 : length(mm_mat)
        eval([cell2mat(mm_mat(i)) '= DECOMPinput.(cell2mat(mm_mat(i)));']);
    end

    K    = length(g_vec);

% A GRID FOR t, MODEL-IMPLIED PDF AND CDF
%--------------------------------------------------------------------------

    dt_size  = 1/2; 
    tgrid = [tmin:dt_size:tmax];
    Nt    = length(tgrid);
    dt = [tgrid(2)-tgrid(1) diff(tgrid)];
       
    Fgrid = zeros(K,Nt);
    fgrid = zeros(K,Nt);
    gsurv = zeros(K,Nt);
        
    for k = 1:K
        mu    = mu_vec(k);
        sigma = sigma_vec(k);
        
        Fgrid(k,:) = fct_CDF_F_capped(tgrid,mu,sigma);    
        gsurv(k,:) = g_vec(k)*(1-Fgrid(k,:));          
    end
    
    gsum = sum(gsurv,1);
    gsurv = gsurv./repmat(gsum,K,1);

    %==========================================
    % DECOMPOSITION OF THE HAZARD RATE

    HR     = 0*fgrid;

    for k = 1:K
        mu    = mu_vec(k);
        sigma = sigma_vec(k);

        Fgrid(k,:) = fct_CDF_F_capped(tgrid,mu,sigma);
        fgrid(k,:) = fct_pdf_f(tgrid,mu,sigma);

        HR(k,:) = fct_hazard(tgrid,mu,sigma);  % use fct hazard
    end

    if min(tgrid) == 0 
        HR(:,1)= 0; % set hazard at time zero equal to zero
    end

    HR_struc        = zeros(Nt,1);
    HR_heter        = zeros(Nt,1);
    delta_HR_S = 0;
    delta_HR_H = 0;
    delta_HR_H_fer = 0;

    % multiplicative decomposition
    log_HR_struc_multi = zeros(Nt,1);
    log_HR_heter_multi = zeros(Nt,1);

    HR_agg = sum(HR.*gsurv,1);  % computes the aggregate hazard rate
    for t = 2:Nt%tmax+1
        tind  = t;                % index: position in the vector

        gsurv_s   = gsurv(:,tind) ;  % g(k,t) is the distribution of suriviers of type k at t
        gsurv_s_1 = gsurv(:,tind-1);
        HR_s   = HR(:,tind)  ; 
        HR_s_1 = HR(:,tind-1);

        dgsurv = (gsurv_s - gsurv_s_1) ; % change in survivers begtween weeks
        index = Fgrid(:,tind)>1-10^(-14);
        dgsurv(index) = 0;

        delta_HR_S = sum((HR_s-HR_s_1).*gsurv_s) ;  % "derivative" of the hazard average with survivor distribution
        delta_HR_H = sum((gsurv_s - gsurv_s_1).*HR_s_1);

        HR_struc(tind) = HR_struc(tind-1) + delta_HR_S ; 
        HR_heter(tind) = HR_heter(tind-1) + delta_HR_H ; % we use the previous one in the past! 
        
        % multiplicative decomposition
        if HR_agg(tind-1)>0
            delta_HR_S_multi(tind)     = delta_HR_S/HR_agg(tind-1);
            delta_HR_H_multi(tind)     = delta_HR_H/HR_agg(tind-1);        
        else
            delta_HR_S_multi(tind)     = 0;
            delta_HR_H_multi(tind)     = 0;
        end    
        log_HR_struc_multi(tind) = log_HR_struc_multi(tind-1) + delta_HR_S_multi(tind);%*dtgrid;
        log_HR_heter_multi(tind) = log_HR_heter_multi(tind-1) + delta_HR_H_multi(tind);%*dtgrid;
    
    end
    
    output.log_HR_struc_multi = log_HR_struc_multi;
    output.log_HR_heter_multi = log_HR_heter_multi;
    output.HR_agg = HR_agg;
%     %HR_agg = sum(HR.*gsurv);
%     HR_agg1 = HR_agg';
%     HR_struc_imp = HR_agg1 - HR_heter; % implied sgtructural change 
%     % computed as Total hazard rate + Variance hazard rate
%     
%     HR_agg_all(kb,:)   = HR_agg';
%     HR_struc_all(kb,:) = HR_struc+HR_heter(1)+HR_agg(1);
%     HR_heter_all(kb,:) = HR_heter-HR_heter(1);
%     
%     log_HR_struc_multi_all(kb,:) = log_HR_struc_multi;
%     log_HR_heter_multi_all(kb,:) = log_HR_heter_multi;

    %==========================================================================
    % MULTIPLICATIVE DECOMPOSITION
    tini = 2; % this corresponds to t=2

    step_t = tgrid(2)-tgrid(1);
    
    HR_heter_multi = exp(step_t*log_HR_heter_multi);    
    HR_struc_multi = HR_agg'./HR_heter_multi;        
%     HR_struc_multi = exp(step_t*log_HR_struc_multi);
%     HR_heter_multi = HR_agg'./HR_struc_multi;    
    
    CC = HR_agg(tini)/HR_struc_multi(tini);
    HR_struc_multi = HR_struc_multi*CC;
    HR_heter_multi = HR_heter_multi/CC;
%     HR_struc_multi = HR_struc_multi/CC;
%     HR_heter_multi = HR_heter_multi*CC;
%     
    output.HR_agg = HR_agg';
    output.HR_struc_multi = HR_struc_multi;
    output.HR_heter_multi = HR_heter_multi;
    output.tgrid = tgrid(:);
    output.gsurv = gsurv;
    
%     figure(30); 
%     subplot(2,1,1)
%     hold on;
%     plot(tgrid,HR_agg,'k.-')
%     plot(tgrid,HR_struc_multi,'r.-')
%     legend('HR aggregate','HR structure')
%     xlabel('non-employment duration, in weeks')
%     title('Multiplicative decomposition of HR: structure')
% 
%     subplot(2,1,2)
%     hold on;
%     plot(tgrid,HR_heter_multi,'b.-')
%     xlabel('non-employment duration, in weeks')
%     title('Multiplicative decomposition of HR: heterogeneity')
return


